<?PHP
/*
 * NotifyMovedThread Plugin!
 * Author: flash.tato
 */

$plugins->add_hook("class_moderation_move_thread_redirect", "notify_moved_thread_handler");
$plugins->add_hook("class_moderation_move_simple", "notify_moved_thread_handler");
$plugins->add_hook("class_moderation_move_threads", "notify_moved_threads_handler");

function notify_moved_thread_info()
{
	return array(
		"name"			=> "هاك تنبيه نقل المواضيع",
		"description"	=> "يقوم بارسال رسالة خاصة للعضو حين نقل موضوعه",
		"author"		=> "flash.tato",
		"authorsite"	=> "http://www.mybboard.it",
		"version"		=> "0.1.1",
		"compatibility" => "16*",
		"guid"			=> "33876c475677a0360f94ed6e6d7f9fbb"
	);
}

function notify_moved_thread_is_installed()
{
	global $db;
	$query = $db->simple_select("settinggroups", "gid", "name='notify_moved_thread'");
	return $db->num_rows($query);
}

function notify_moved_thread_install()
{
	global $db;
	$settings_group = array(
		"gid"            => "NULL",
		"title"          => "هاك تنبيه نقل المواضيع",
		"name"           => "notify_moved_thread",
		"description"    => "اعدادات الهاك",
		"disporder"      => '10',
		"isdefault"      => "0"
	);
	$db->insert_query("settinggroups", $settings_group);
	$gid = $db->insert_id();
	$setting_1 = array(
		"sid"            => "NULL",
		"name"           => "notify_moved_thread_pm_sender",
		"title"          => "العضو المرسل",
		"description"    => " ادخل ايدي العضو المراد ان يظهر في اسم المرسل",
		"optionscode"    => "text",
		"value"          => '',
		"disporder"      => '1',
		"gid"            => $gid
	);
	$db->insert_query("settings", $setting_1);
	$setting_2 = array(
		"sid"            => "NULL",
		"name"           => "notify_moved_thread_pm_subject",
		"title"          => "عنوان الرسالة",
		"description"    => "ادخل عنوان الرسالة الذي سوف تصل للعضو",
		"optionscode"    => "text",
		"value"          => 'تم نقل موضوعك',
		"disporder"      => '2',
		"gid"            => $gid
	);
	$db->insert_query("settings", $setting_2);
	$setting_3 = array(
		"sid"            => "NULL",
		"name"           => "notify_moved_thread_pm_message",
		"title"          => "محتوي الرسالة",
		"description"    => "قم بادخال محتوي الرسالة وتستطيه استخدام القيم الثابتة في الرسالة كما في المثال",
		"optionscode"    => "textarea",
		"value"          => 'مرحبا {thread_author},\nالموضوع الخاص بك [URL={thread_link}]{thread_subject}[/URL] تم نقله الي [URL={forum_link}]{forum_name}[/URL] بواسطة {thread_mover_username}\nمع اطيب التحيات',
		"disporder"      => '3',
		"gid"            => $gid
	);
	$db->insert_query("settings", $setting_3);
	rebuild_settings();
}

function notify_moved_thread_uninstall()
{
	global $db;
	$db->delete_query("settings", "name IN ('notify_moved_thread_pm_sender', 'notify_moved_thread_pm_subject', 'notify_moved_thread_pm_message')");
	$db->delete_query("settinggroups", "name='notify_moved_thread'");
	rebuild_settings();
}

function notify_moved_thread_handler($arguments)
{
	global $mybb, $newforum, $thread;
	notify_moved_thread($thread, $newforum);
}

function notify_moved_threads_handler($arguments)
{
	global $newforum;
	foreach($arguments['tids'] as $tid)
	{
		$thread = get_thread($tid);
		$forum = get_forum($thread['fid']);
		notify_moved_thread($thread, $newforum);
	}
}

function notify_moved_thread($thread, $newforum)
{
	global $mybb;
	$user = get_user($thread['uid']);
	require_once MYBB_ROOT."inc/datahandlers/pm.php";
	$pmhandler = new PMDataHandler();
	$pm = array(
		"subject" => $mybb->settings['notify_moved_thread_pm_subject'],
		"toid" => array($thread['uid'])
	);
	$find = array("{thread_author}", "{thread_mover_username}", "{thread_link}", "{thread_subject}",  "{forum_link}", "{forum_name}");
	$replace = array($user['username'], $mybb->user['username'], $mybb->settings['bburl'] . "/" . str_replace("{tid}", $thread['tid'], THREAD_URL), $thread['subject'], $mybb->settings['bburl'] . "/" . str_replace("{fid}", $newforum['fid'], FORUM_URL), $newforum['name']);
	$pm['message'] = str_replace($find, $replace, $mybb->settings['notify_moved_thread_pm_message']);
	if(is_numeric($mybb->settings['notify_moved_thread_pm_sender']))
	{
		$pm['fromid'] = $mybb->settings['notify_moved_thread_pm_sender'];
	}
	else
	{
		$pm['fromid'] = $mybb->user['uid'];
	}
	$pmhandler->set_data($pm);
	if($pmhandler->validate_pm())
	{
		$pminfo = $pmhandler->insert_pm();
		return $pminfo;
	}
}

?>